VERSION 4.00
Begin VB.Form frmExport 
   Appearance      =   0  'Flat
   BackColor       =   &H80000005&
   Caption         =   "VB/ISAM Sample Program SAM3 -- Export to .CSV"
   ClientHeight    =   972
   ClientLeft      =   1152
   ClientTop       =   2148
   ClientWidth     =   6828
   ControlBox      =   0   'False
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   1
      weight          =   700
      size            =   7.8
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   1320
   Left            =   1104
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   972
   ScaleWidth      =   6828
   Top             =   1848
   Width           =   6924
   Begin Threed.SSPanel pnlStopButton 
      Height          =   972
      Left            =   5460
      TabIndex        =   1
      Top             =   0
      Width           =   1368
      _version        =   65536
      _extentx        =   2413
      _extenty        =   1715
      _stockprops     =   15
      forecolor       =   16711680
      backcolor       =   12632256
      bevelinner      =   1
      Begin Threed.SSCommand cmdStop 
         Height          =   795
         Left            =   90
         TabIndex        =   2
         Top             =   90
         Width           =   1185
         _version        =   65536
         _extentx        =   2096
         _extenty        =   1397
         _stockprops     =   78
         caption         =   "Stop"
         BeginProperty font {FB8F0823-0164-101B-84ED-08002B2EC713} 
            name            =   "MS Sans Serif"
            charset         =   1
            weight          =   400
            size            =   7.8
            underline       =   0   'False
            italic          =   0   'False
            strikethrough   =   0   'False
         EndProperty
         outline         =   0   'False
         picture         =   "SAM3EXPO.frx":0000
      End
   End
   Begin Threed.SSPanel pnlGauge 
      Height          =   975
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   5445
      _version        =   65536
      _extentx        =   9610
      _extenty        =   1715
      _stockprops     =   15
      forecolor       =   0
      backcolor       =   12632256
      BeginProperty font {FB8F0823-0164-101B-84ED-08002B2EC713} 
         name            =   "MS Sans Serif"
         charset         =   1
         weight          =   700
         size            =   12
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      bevelinner      =   1
      floodtype       =   1
      floodcolor      =   32768
   End
End
Attribute VB_Name = "frmExport"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Dim StopFlag As Integer

Private Sub cmdStop_Click()

    Close #ExportFileNum
    Kill ExportFileName

    StopFlag = True 'Main loop in Form_Activate will see this after DoEvents

End Sub

Private Sub Form_Activate()

    Dim TempString As String
    Dim PKey As String
    Dim CSVString As String
    Dim LinesWritten As Long
    Dim PercentExported As Integer


    'Refresh RecordsInFile information (may have added/deleted records):
    rc = VmxInfo(DatasetRefNum, DatasetInfo)
    If rc <> VIS_OK Then
        TellUser (INFO_ERROR)
        ExitProgram 'Panic exit
    End If

    rc = VmxBOF(DatasetRefNum, 0)
    LinesWritten = 0
    PercentExported = 0
    StopFlag = False    'see cmdStop
    rc = VmxGet(DatasetRefNum, 0, XNEXT, "", Throwaway, PKey, ExportRecBuffer)  '"prime" the loop
                'CSVString = CSVString & "," & Format$(TempCurrency, "Standard")

    Do While rc = VIS_OK

        CSVString = QuoteMaybe(PKey)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.Description)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.ProductCategory)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.FileType)
        CSVString = CSVString & "," & QuoteMaybe(Format$(ExportRecBuffer.BasePrice, "Standard"))
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.PricingNotes)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.CatalogPage)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.CompanyName)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.Phone)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.Fax)
        CSVString = CSVString & "," & QuoteMaybe(ExportRecBuffer.Comments)
        CSVString = CSVString & CRLFDelim

        Put #ExportFileNum, , CSVString
        LinesWritten = LinesWritten + 1

        PercentExported = Int((LinesWritten / DatasetInfo.RecordsInFile) * 100)
        If (PercentExported - pnlGauge.FloodPercent) >= 5 Then  'Update the indicator every 5%
            pnlGauge.FloodPercent = PercentExported
            DoEvents    'Be nice to Windows (also listen for StopFlag)
            If StopFlag = True Then
                TellUser (EXPORT_ABORTED)
                Me.Hide
                Exit Sub
            End If
        End If

        rc = VmxGet(DatasetRefNum, 0, XNEXT, "", Throwaway, PKey, ExportRecBuffer)

    Loop

    'Make sure we finished the loop because we got to the end:
    If rc <> VIS_NOT_FOUND Then
        MBType = MB_ICONEXCLAMATION
        Msg = "VmxGet error: " & Chr$(34) & VmxReturnCode$(rc) & Chr$(34) & " ...after exporting" & Str$(LinesWritten) & " lines."
        MsgBox Msg, MBType, MBTitle
        Close #ExportFileNum
    Else
        Close #ExportFileNum
        MBType = MB_ICONINFORMATION
        Msg = "Export complete."
        MsgBox Msg, MBType, MBTitle
    End If

    Me.Hide

End Sub

Private Function QuoteMaybe(SourceString As String) As String

    If InStr(SourceString, ",") = 0 Then
        QuoteMaybe = SourceString
    Else
        QuoteMaybe = Chr$(34) & SourceString & Chr$(34)   'double-quotes
    End If

End Function

